#*****************************************************************************
#                                                                            *
# Make file for VMS                                                          *
# Author : J.Jansen (joukj@hrem.nano.tudelft.nl)                             *
# Date : 18 September 2025                                                   *
#                                                                            *
#*****************************************************************************

.first
	define brotli [-.include.brotli]

CFLAGS=/name=(as_is,short)/float=ieee/warn=(noinfo,disab=BADALIAS)

OBJS=backward_references.obj,backward_references_hq.obj,bit_cost.obj,\
	block_splitter.obj,brotli_bit_stream.obj,cluster.obj,command.obj,\
	compound_dictionary.obj,compress_fragment.obj,\
	compress_fragment_two_pass.obj,dictionary_hash.obj,encode.obj,\
	encoder_dict.obj,entropy_encode.obj,fast_log.obj,histogram.obj,\
	literal_cost.obj,memory.obj,metablock.obj,static_dict.obj,\
	static_dict_lut.obj,static_init_enc.obj,utf8_util.obj

all : $(OBJS)
	library [--]libbrotli.olb $(OBJS)
	@ write sys$output "all done in [.c.enc]"

backward_references.obj : backward_references.c
backward_references_hq.obj : backward_references_hq.c
bit_cost.obj : bit_cost.c
block_splitter.obj : block_splitter.c
brotli_bit_stream.obj : brotli_bit_stream.c
cluster.obj : cluster.c
command.obj : command.c
compound_dictionary.obj : compound_dictionary.c
compress_fragment.obj : compress_fragment.c
compress_fragment_two_pass.obj : compress_fragment_two_pass.c
dictionary_hash.obj : dictionary_hash.c
encode.obj : encode.c
encoder_dict.obj : encoder_dict.c
entropy_encode.obj : entropy_encode.c
fast_log.obj : fast_log.c
histogram.obj : histogram.c
literal_cost.obj : literal_cost.c
memory.obj : memory.c
metablock.obj : metablock.c
static_dict.obj : static_dict.c
static_dict_lut.obj : static_dict_lut.c
static_init_enc.obj : static_init.c
	copy static_init.c static_init_enc.c
	cc$(CFLAGS) static_init_enc.c
	delete static_init_enc.c;*
utf8_util.obj : utf8_util.c
